#!/bin/sh

PATH=/sbin:/bin:/usr/sbin:/usr/bin

# for a chrooted server: "-u bind -t /var/lib/named"
# Don't modify this line, change or create /etc/default/bind9.
OPTIONS=""

test -f /etc/default/bind9 && . /etc/default/bind9

test -x /usr/sbin/rndc || exit 0

case "$1" in
    start)
	echo -n "Starting domain name service: named"

	modprobe capability >/dev/null 2>&1 || true
	if [ ! -f /etc/bind/rndc.key ]; then
	    /usr/sbin/rndc-confgen -a -b 512 -r /dev/urandom
	    chmod 0640 /etc/bind/rndc.key
	fi
	if [ -f /var/run/named/named.pid ]; then
	    ps `cat /var/run/named/named.pid` > /dev/null && exit 1
	fi

	# dirs under /var/run can go away on reboots.
	mkdir -p /var/run/named
	mkdir -p /var/cache/bind
	chmod 775 /var/run/named
	chown root:bind /var/run/named >/dev/null 2>&1 || true

	if [ ! -x /usr/sbin/named ]; then
	    echo "named binary missing - not starting"
	    exit 1
	fi
	if start-stop-daemon --start --quiet --exec /usr/sbin/named \
		--pidfile /var/run/named/named.pid -- $OPTIONS; then
	    if [ -x /sbin/resolvconf ] ; then
		echo "nameserver 127.0.0.1" | /sbin/resolvconf -a lo
	    fi
	fi
	echo "."	
    ;;

    stop)
	echo -n "Stopping domain name service: named"
	if [ -x /sbin/resolvconf ]; then
	    /sbin/resolvconf -d lo
	fi
	/usr/sbin/rndc stop >/dev/null 2>&1
	echo "."	
    ;;

    reload)
	/usr/sbin/rndc reload
    ;;

    restart|force-reload)
	$0 stop
	sleep 2
	$0 start
    ;;
    
    *)
	echo "Usage: /etc/init.d/bind {start|stop|reload|restart|force-reload}" >&2
	exit 1
    ;;
esac

exit 0
