/*
 * Copyright (C) 2012-2020 Panasonic Corporation.
 *
 */

#define assert(expr) \
	if (!(expr)) { \
		printk("Assertion failed! %s,%s,%s,line=%d\n", \
		#expr, __FILE__, __func__, __LINE__); \
	}

#define _READB(_reg)     		readb((volatile void __iomem*)(_reg))
#define _READL(_reg)     		readl((volatile void __iomem*)(_reg))
#define _WRITEB(_val, _reg)     writeb((u8)(_val), (volatile void __iomem*)(_reg))
#define _WRITEL(_val, _reg)     writel((u32)(_val), (volatile void __iomem*)(_reg))

#define _REG_R8(_reg)           _READB(_reg)
#define _REG_R16(_reg)          _READW(_reg)
#define _REG_R32(_reg)          _READL(_reg)

#define _REG_W8(_reg, _val)     _WRITEB(_val, _reg)
#define _REG_W16(_reg, _val)    _WRITEW(_val, _reg)
#define _REG_W32(_reg, _val)    _WRITEL(_val, _reg)

#define _REG_SET8(_reg, _val) \
    _REG_W8((_reg), _REG_R8(_reg) | (u8)(_val))
#define _REG_SET16(_reg, _val) \
    _REG_W16((_reg), _REG_R16(_reg) | (u16)(_val))
#define _REG_SET32(_reg, _val) \
    _REG_W32((_reg), _REG_R32(_reg) | (u32)(_val))

#define _REG_SETM8(_reg, _val, _mask) \
    _REG_W8((_reg), (_REG_R8(_reg) & (u8)(_mask)) | (u8)(_val))
#define _REG_SETM16(_reg, _val, _mask) \
    _REG_W16((_reg), (_REG_R16(_reg) & (u16)(_mask)) | (u16)(_val))
#define _REG_SETM32(_reg, _val, _mask) \
    _REG_W32((_reg), (_REG_R32(_reg) & (u32)(_mask)) | (u32)(_val))

#define _REG_CLR8(_reg, _val) \
    _REG_W8((_reg), (_REG_R8(_reg) & (~(u8)(_val))))
#define _REG_CLR16(_reg, _val) \
    _REG_W16((_reg), (_REG_R16(_reg) & (~(u16)(_val))))
#define _REG_CLR32(_reg, _val) \
    _REG_W32((_reg), (_REG_R32(_reg) & (~(u32)(_val))))

#define _REG_TEST8(_reg, _val) \
    ((_REG_R8(_reg) & (u8)(_val)) != 0 ? 1 : 0)
#define _REG_TEST16(_reg, _val) \
    ((_REG_R16(_reg) & (u16)(_val)) != 0 ? 1 : 0)
#define _REG_TEST32(_reg, _val) \
    ((_REG_R32(_reg) & (u32)(_val)) != 0 ? 1 : 0)


#if defined(CONFIG_USB_PANASONIC_V9AHD)
#include "xhci-panasonic-register-v9ahd.h"
#endif
#if defined(CONFIG_USB_PANASONIC_PRO4R)
#include "xhci-panasonic-register-pro4r.h"
#endif


