/*
 * Copyright (C) 2012-2020 Panasonic Corporation.
 */

#if defined(CONFIG_USB_PANASONIC_V9AHD)

#ifdef CONFIG_USB_IGNORE_CERR
static u8	usb_xhci_target = 1;
#endif

/*_------------------------------------------------------------------------
	USB3(XHCI) SoCレジスタ定義
------------------------------------------------------------------------_*/

/*_ @LINUXHOST:V0303nd[11/12/12] xHCI 割り込み番号変更 _*/
#define XHCI_BASE_ADR_0           (0x7C200000)    /*_ host #0 XHCI Base Address	_*/
#define XHCI_IRQ_NUM_0            (151)           /*_ host #0 XHCI IRQ NUM(ARM)	_*/

#define XHCI_MEM_LEN              (0x7FFF)

static const struct resource host_res[][2] = {
	{
		{
			.start	= XHCI_BASE_ADR_0,
			.end	= XHCI_BASE_ADR_0 + XHCI_MEM_LEN - 1,
			.flags	= IORESOURCE_MEM,
		}, {
			.start	= XHCI_IRQ_NUM_0,
			.flags	= IORESOURCE_IRQ,
		},
	},
};


///#define XHCI_USB3_VBUS_CONTROL_OFFSET   (0x00000400)	/*_ USB3 VBUS OFFSET FROM cap_reg _*/
#ifdef XHCI_USB3_VBUS_CONTROL_OFFSET
#define XHCI_USB3_VBUS_DRVVBUS_REG_EN   (1<<3)		/*_ VBUS ON Controled by EN _*/
#define XHCI_USB3_VBUS_DRVVBUS_REG      (1<<4)		/*_ VBUS ON _*/
#endif /* XHCI_USB3_VBUS_CONTROL_OFFSET */
///#define XHCI_USB3_VBUS_CONTROL_REG_0	(XHCI_BASE_ADR_0 + 0xCC00 + 0x00) /*_ USB3 VBUS Control _*/
///#define XHCI_RESET_CTL_REG_0      (XHCI_BASE_ADR_0 + 0xCC00 + 0x40) /*_  Reset Control Register (USB0) _*/

///#define XHCI_USB3_TESTI_REG_0     (XHCI_BASE_ADR_0 + 0xCC00 + 0x10) /*_ SS-PHY set register _*/
///#define XHCI_USB3_TESTO_REG_0     (XHCI_BASE_ADR_0 + 0xCC00 + 0x14) /*_ SS-PHY dummy register _*/


/*_---------------------------------------------------------------------------
     ハードウェア開始(初期化)処理
---------------------------------------------------------------------------_*/
static inline void xhci_panasonic_peripheryhw_init( void )
{
#ifdef XHCI_USB3_VBUS_CONTROL_REG_0
	{
		u32 tmp;
		
		/*_ Control the VBUS by xHCI driver _*/
		tmp = readl((void*) XHCI_USB3_VBUS_CONTROL_REG_0);
		tmp |= 0x00000018;	/*_ 連動解除およびVBUSのON  _*/
		writel( tmp, (void*)XHCI_USB3_VBUS_CONTROL_REG_0);
		
		/*_ Wait for the VBUS is stable _*/
		msleep(30);
	}
#endif	/* XHCI_USB3_VBUS_CONTROL_REG_0 */
	
#ifdef XHCI_RESET_CTL_REG_0
	{
		u32 tmp;
		
		/*_ IOMMU &  LINK リセット解除 _*/
		tmp = readl((void*) XHCI_RESET_CTL_REG_0);
		tmp |= 0x00000030;
		writel( tmp, (void*)XHCI_RESET_CTL_REG_0 );
		/*_ PLL安定待ち(必要なし?) _*/
		//msleep(1);
	}
#endif	/* XHCI_RESET_CTL_REG_0 */

#if defined(XHCI_USB3_TESTI_REG_0) && defined(XHCI_USB3_TESTO_REG_0)
	/*_ SS PHY設定 _*/
	{
		u32 tmp;
		int i;
		
		/*_ SS PHY設定はReset時にクリアされるため、xhci.cのxhci_resetでも再設定している _*/
		/*_ 設定値はハード部門から連絡 _*/
		writel( 0x00000206, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		/*_ 各書き込みの間には80ns以上の間隔が必要 _*/
		/*_ ダミーリードして時間調整を行う場合は読み出しx10で調整する _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000207, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000206, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000008e, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000008f, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000008e, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000027c, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000027d, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000027c, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x000002b8, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x000002b9, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x000002b8, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000102, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000103, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000102, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000022a, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000022b, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000022a, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x000000ac, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x000000ad, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x000000ac, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000100, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000101, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x00000100, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000009a, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000009b, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
		for(i = 0;i < 10;i++){
			tmp = readl((void*)XHCI_USB3_TESTO_REG_0);
		}
		writel( 0x0000009a, (void*)XHCI_USB3_TESTI_REG_0 );		/*_ SS-PHY(USB0) _*/
	}
#endif
	
	/*_ check HCRST bit (USBCMD Reg) _*/
	{
///		u32 caplen;
///		u32 tmp;
///		
///		caplen = 0xFF & readl((void*) XHCI_BASE_ADR_0);
///		tmp = readl((void*) (XHCI_BASE_ADR_0 + caplen) );
///		if(tmp & 0x2) 	printk(KERN_ERR "Usb3-0 init error \n");
	}
}

/*_---------------------------------------------------------------------------
     ハードウェア終了処理
---------------------------------------------------------------------------_*/
static inline void xhci_panasonic_peripheryhw_end( void )
{
#ifdef XHCI_RESET_CTL_REG_0
	{
		u32 tmp;
		
		/*_ IOMMU &  LINK リセット _*/
		tmp = readl((void*) XHCI_RESET_CTL_REG_0);
		tmp &= ~0x00000030;
		writel( tmp, (void*)XHCI_RESET_CTL_REG_0 );
	}
#endif	/* XHCI_RESET_CTL_REG_0 */
}

#endif /* CONFIG_USB_PANASONIC_V9AHD */
