/**
 * dwc3-pvc03v.c - Pvc03v Specific Glue layer
 *
 * Copyright (C) 2016-2020 Panasonic Corporation.
 *
 * Author: Panasonic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2  of
 * the License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/clk.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/interrupt.h>
#include <linux/platform_device.h>
#include <linux/dma-mapping.h>
#include <linux/io.h>
#include <linux/of_platform.h>

static int pdwc3_probe(struct platform_device *pdev)
{
	struct device			*dev = &pdev->dev;
	struct device_node		*node = pdev->dev.of_node;
	int error;

	error = of_platform_populate(node, NULL, NULL, dev);
	if (error){
		dev_err(&pdev->dev, "failed to create dwc3 core\n");
		return error;
	}	
		
	return 0;
}

static int pdwc3_remove(struct platform_device *pdev)
{
	of_platform_depopulate(&pdev->dev);

	return 0;
}

static const struct of_device_id pdwc3_of_match[] = {
	{ .compatible = "panasonic,pvc03v-dwc3", },
	{},
};
MODULE_DEVICE_TABLE(of, pdwc3_of_match);

static struct platform_driver pdwc3_driver = {
	.probe		= pdwc3_probe,
	.remove		= pdwc3_remove,
	.driver		= {
		.name	= "pvc03v-dwc3",
		.of_match_table	= pdwc3_of_match,
	},
};

module_platform_driver(pdwc3_driver);

MODULE_ALIAS("platform:pvc03v-dwc3");
MODULE_AUTHOR("Panasonic");
MODULE_LICENSE("GPL v2");
MODULE_DESCRIPTION("DesignWare USB3 Pvc03v Glue Layer");
