/*
 * Copyright (C) 2012-2020 Panasonic Corporation.
 *
 */

#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/module.h>
#include <linux/moduleparam.h>

#include "usb-panasonic.h"

/*_ ۥͭ/̵ե饰 _*/
static uint usb_ehci_host_ebable=0x0;
static uint usb_xhci_host_ebable=0x0;
module_param(usb_ehci_host_ebable, uint, S_IRUGO | S_IWUSR);
MODULE_PARM_DESC(usb_ehci_host_ebable, "echi enable info");
module_param(usb_xhci_host_ebable, uint, S_IRUGO | S_IWUSR);
MODULE_PARM_DESC(usb_xhci_host_ebable, "xchi enable info");

/*_ ɥ饤ХС _*/
static uint usb_hostdd_version=USBH_DDVERSION;
module_param(usb_hostdd_version, uint, S_IRUGO);
MODULE_PARM_DESC(usb_hostdd_version, "usb host driver version");


/*_ @ۥͭ/̵ưŪ  _*/
uint usbh_get_host_enableinfo(int controller_type)
{

	uint ret_val = 0x0;

	switch(controller_type){
		
		case USBH_ENABLEINFO_EHCI:	/*_ echi _*/
			ret_val = usb_ehci_host_ebable;
			break;

		case USBH_ENABLEINFO_XHCI:	/*_ xchi _*/
			ret_val = usb_xhci_host_ebable;
			break;
			
		default:
			ret_val = 0x0;
			break;
	}

	return ret_val;
}

EXPORT_SYMBOL_GPL(usbh_get_host_enableinfo);

