/*
 *  Copyright (C) 2015-2020 Panasonic Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */

#ifndef __PVC_SDIO_H
#define __PVC_SDIO_H

#define PVCSD_HOST_CTRL_TMOUT_MASK 		(0xee)
#define PVCSD_HOST_CTRL_TMOUT_EN 		(0xee)

#define PVCSD_HOST_CTRL_DATA_WIDTH_4_BITS 	(1 << 15)
#define PVCSD_CMD_INDEX(x)			((x) << 8)
#define PVCSD_RSP(i)				(0x30 + ((i)<<3))
#define PVCSD_AUTO_RSP(i)			(0x30 + ((i)<<3))

#define PVCSD_ERR_RSP_TIMEOUT			(1 << 6)
#define PVCSD_ERR_ILL_READ			(1 << 5)
#define PVCSD_ERR_ILL_WRITE			(1 << 4)
#define PVCSD_ERR_DATA_TIMEOUT			(1 << 3)
#define PVCSD_ERR_END				(1 << 2)
#define PVCSD_ERR_CRC				(1 << 1)
#define PVCSD_ERR_CMD				(1)

#define PVCSD_ERR_AUTOCMD12			0x4F
#define PVCSD_IO_IRQ				(1)
#define PVCSD_TID_SDRAM_CH0			0x8
#define PVCSD_TID_SDRAM_CH1			0x9

#define PVCSD_TID_SD0				0x2
#define PVCSD_TID_SD1				0x1
#define PVCSD_TID_SD2				0x7

#define PVCSD_CDXST_STOP_BIT			(1 << 31)

#define PVCSD_CMD_RSP_NONE			(0x3 << 8)
#define PVCSD_CMD_RSP_48			(0x4 << 8)
#define PVCSD_CMD_RSP_48BUSY			(0x5 << 8)
#define PVCSD_CMD_RSP_136			(0x6 << 8)

#define PVCSD_CMD_DATA_PRESENT			(1 << 11)
#define PVCSD_CMD_READ				(1 << 12)

#define PVCSD_NOR_CMD_DONE			(1 << 0)
#define PVCSD_NOR_RW_DONE			(1 << 2)
#define PVCSD_NOR_BRE				(1 << 8)
#define PVCSD_NOR_BWE				(1 << 9)

#define PVCSD_SD_STOP_CLK			0x0020
#define PVCSD_SD_ENABLE_CLK			(1 << 8)
#define PVCSD_BASE_DIV_MAX			512
#define PVCSD_SDIO_ENABLE			0x00000001
#define PVCSD_AUTO_STOP				(1 << 8)

#define PVCSD_RX_READY				(1 << 8)
#define PVCSD_TX_AVAIL				(1 << 9)
#define PVCSD_CARD_INT				(1 << 0)

#define PVCSD_ERROR_BIT				0x0000007F

#define PVCSD_STATE_CBSY			(1 << 14)

#define PVCSD_CLKDEV_IDENT			0x1
#define PVCSD_CLKDEV_STBY			0x2
#define PVCSD_CLKDEV_DATA			0x4
#define PVCSD_CLKDEV_STOP			0x0
#define PVCSD_CLKDEV_DIV2			0x0
#define PVCSD_CLKDEV_DIV128			(1 << 5)

#define PVCSD_PIO_MODE				(0)
#define PVCSD_DMA_MODE				(1 << 1)

#define PVCSD_TRANS_ERROR -1
#define PVCSD_TRANS_WAIT_COUNT			1000
#define PVCSD_TRANS_DONE			(1 << 1)

#define PVCSD_INFO1_STMASK			0xffe7

#define PVCSD_INFO1_RESPONSE_END		(1 << 0)
#define PVCSD_INFO1_RW_END			(1 << 2)
#define PVCSD_INFO1_CARD_REMOVE			(1 << 3)
#define PVCSD_INFO1_CARD_INSERT			(1 << 4)
#define PVCSD_INFO1_CARD_DETECT			(1 << 5)
#define PVCSD_INFO1_WRITE_PROTECT		(1 << 7)
#define PVCSD_INFO1_SDDAT3_REMOVE		(1 << 8)
#define PVCSD_INFO1_SDDAT3_INSERT		(1 << 9)
#define PVCSD_INFO1_SDDAT3_DETECT		(1 << 10)

#define PVCSD_INFO1_INSERT_DEF (PVCSD_INFO1_SDDAT3_INSERT | \
				PVCSD_INFO1_SDDAT3_REMOVE | \
				PVCSD_INFO1_CARD_INSERT | \
				PVCSD_INFO1_RW_END)

#define PVCSD_INFO1_REMOVE_DEF (PVCSD_INFO1_SDDAT3_INSERT | \
				PVCSD_INFO1_SDDAT3_REMOVE | \
				PVCSD_INFO1_CARD_REMOVE | \
				PVCSD_INFO1_RW_END)

#define PVCSD_INFO1_EXT_DEF (PVCSD_INFO1_CARD_REMOVE | \
				PVCSD_INFO1_CARD_INSERT	| \
				PVCSD_INFO1_CARD_DETECT | \
				PVCSD_INFO1_WRITE_PROTECT | \
				PVCSD_INFO1_SDDAT3_REMOVE | \
				PVCSD_INFO1_SDDAT3_INSERT | \
				PVCSD_INFO1_SDDAT3_DETECT)

#define PVCSD_INFO1_MASK_EXT_DEF (PVCSD_INFO1_CARD_REMOVE | \
				PVCSD_INFO1_CARD_INSERT	| \
				PVCSD_INFO1_SDDAT3_REMOVE | \
				PVCSD_INFO1_SDDAT3_INSERT)

#define PVCSD_INFO2_RESET_MASK 0x837f

#define PVCSD_INFO2_DAT0			(1 << 7)

#define CMD5		5
#define CMD6		6
#define CMD13		13
#define CMD17		17
#define CMD18		18
#define CMD24		24
#define CMD25		25
#define CMD52		52
#define CMD53		53
#define CMD54		54

#define ACMD6		6
#define ACMD8		8
#define ACMD13		13
#define ACMD22		22
#define ACMD23		23
#define ACMD41		41
#define ACMD42		42
#define ACMD51		51

#endif
