/*
 * Copyright (C) 2015-2020 Panasonic Corporation.
 *
 * This file is licensed under the terms of the GNU General Public
 * License version 2.  This program is licensed "as is" without any
 * warranty of any kind, whether express or implied.
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/of_platform.h>
#include <asm/mach/arch.h>
#include <asm/mach/map.h>
#include <asm/memory.h>
#include <mach/board.h>

#ifdef CONFIG_PVC_CMN_EXCLUSION
#include <common_spin_lock.h>
#endif

static void __init pvc_map_io(void);

static struct map_desc pvc_io_desc[] __initdata = {

	{
		.virtual	= PVC_CKR_BASE,
		.pfn		= __phys_to_pfn(PVC_CKR_START),
		.length		= PVC_CKR_SIZE,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= PVC_KERNEL_UNCACHE_BASE,
#ifdef CONFIG_PHYS_OFFSET
		.pfn		= __phys_to_pfn(PVC_KERNEL_UNCACHE_START),
#else	/* CONFIG_PHYS_OFFSET */
		.pfn		= 0UL,
#endif	/* CONFIG_PHYS_OFFSET */
		.length		= PVC_KERNEL_UNCACHE_SIZE,
		.type		= MT_DEVICE,
	},
#ifdef CONFIG_PVC_CMN_EXCLUSION
	{
		.virtual	= LINUX_EXCLUSION_MAP_VADDR,
		.pfn		= __phys_to_pfn(LINUX_EXCLUSION_MAP_PADDR),
		.length		= LINUX_EXCLUSION_MAP_SIZE,
		.type		= MT_MEMORY_PVC_EXCLUSION,
	},
#endif
};

/*
 * Kernel address mapping
 */
static void __init pvc_map_io(void)
{
#ifndef CONFIG_PHYS_OFFSET
	pvc_io_desc[1].pfn = __phys_to_pfn(PVC_KERNEL_UNCACHE_START);
#endif	/* CONFIG_PHYS_OFFSET */
	iotable_init(pvc_io_desc, ARRAY_SIZE(pvc_io_desc));
}

static void __init pvc_init_early(void)
{
	u32 value;

	/* reset cancel */
	value = (PVC_HCKR_TIMER10_PRESET | PVC_HCKR_TIMER11_PRESET);

	writel(value, (void __iomem *)PVC_HCKR_RST_TIMER10_11_VADDR);

	/* clock on */
	value = (PVC_HCKR_TIMER10_PCLK | PVC_HCKR_TIMER10_TIMCLK |
		 PVC_HCKR_TIMER11_PCLK | PVC_HCKR_TIMER11_TIMCLK);
	writel(value, (void __iomem *)PVC_HCKR_CLK_TIMER10_11_VADDR);
}

static const char * const pvc_board_dt_compat[] = {
	"panasonic,pvc03v",
	NULL,
};

DT_MACHINE_START(PVC_DT, "Panasonic PVCPF (Device Tree)")
	.dt_compat	= pvc_board_dt_compat,
	.map_io		= pvc_map_io,
	.init_early	= pvc_init_early,
MACHINE_END
