/*
 * arch/arm/mach-pvc/include/mach/pvc.h
 *
 * Copyright (C) 2015-2020 Panasonic Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef __ASM_ARCH_PVC_H
#define __ASM_ARCH_PVC_H

#if defined(CONFIG_ARCH_PVC)

#define PVCSD_CMD		0x000
#define PVCSD_PORTSEL		0x008
#define PVCSD_ARG0		0x010
#define PVCSD_ARG1		0x018
#define PVCSD_STOP		0x020
#define PVCSD_SECCNT		0x028
#define PVCSD_RSP0		0x030
#define PVCSD_RSP1		0x038
#define PVCSD_RSP2		0x040
#define PVCSD_RSP3		0x048
#define PVCSD_RSP4		0x050
#define PVCSD_RSP5		0x058
#define PVCSD_RSP6		0x060
#define PVCSD_RSP7		0x068
#define PVCSD_INFO1		0x070
#define PVCSD_INFO2		0x078
#define PVCSD_INFO1_MASK	0x080
#define PVCSD_INFO2_MASK	0x088
#define PVCSD_CLK_CTRL		0x090
#define PVCSD_SIZE		0x098
#define PVCSD_OPTION		0x0A0
#define PVCSD_ERR_STS1		0x0B0
#define PVCSD_ERR_STS2		0x0B8
#define PVCSD_BUF0		0x0C0
#define PVCSD_SDIO_MODE		0x0D0
#define PVCSD_SDIO_INFO1	0x0D8
#define PVCSD_SDIO_INFO1_MASK	0x0E0
#define PVCSD_CC_EXT_MODE	0x360
#define PVCSD_SOFT_RST		0x380
#define PVCSD_VERSION		0x388
#define PVCSD_HOST_MODE		0x390
#define PVCSD_SD_STATUS 	0x3C8
#define PVCSD_EXT_SDIO		0x3D0
#define PVCSD_EXT_WP		0x3D8
#define PVCSD_EXT_CD		0x3E0
#define PVCSD_EXT_CD_DAT3	0x3E8
#define PVCSD_EXT_CD_MASK	0x3F0
#define PVCSD_EXT_CD_DAT3_MASK	0x3F8

#define PVCSD_HOST_MODE_WMODE	0x000

#define PVCSD_CLOCKRATE_MAX	49500000

struct pvcsdio_platform_data {
	unsigned int clock;
};

#define PVCSD_DM_CM_SEQ_REGSET  0x0800
#define PVCSD_DM_CM_SEQ_MODE 	0x0808
#define PVCSD_DM_CM_SEQ_CTRL 	0x0810
#define PVCSD_DM_CM_DTRAN_MODE  0x0820
#define PVCSD_DM_CM_DTRAN_CTRL  0x0828
#define PVCSD_DM_CM_RST		0x0830
#define PVCSD_DM_CM_INFO1	0x0840
#define PVCSD_DM_CM_INFO1_MASK	0x0848
#define PVCSD_DM_CM_INFO2	0x0850
#define PVCSD_DM_CM_INFO2_MASK  0x0858
#define PVCSD_DM_CM_TUNING_STAT 0x0860
#define PVCSD_DM_CM_SEQ_STAT 	0x0868
#define PVCSD_DM_DTRAN_ADDR	0x0880
#define PVCSD_DM_SEQ_CMD	0x08A0
#define PVCSD_DM_SEQ_ARG	0x08A8
#define PVCSD_DM_SEQ_SIZE	0x08B0
#define PVCSD_DM_SEQ_SECCNT	0x08B8
#define PVCSD_DM_SEQ_RSP	0x08C0
#define PVCSD_DM_SEQ_RSP_CHK	0x08C8
#define PVCSD_DM_SEQ_ADDR	0x08D0

/* DM_CM_DTRAN_MODE */
#define PVCSD_DM_CM_DTRAN_MODE_CH_NUM_DOWN	(0x00000000)	/* DMAC channel selector 00 : SD/UHS2 down stream */
#define PVCSD_DM_CM_DTRAN_MODE_CH_NUM_UP	(0x00010000)	/* DMAC channel selector 01 : SD/UHS2 up stream */
#define PVCSD_DM_CM_DTRAN_MODE_CH_NUM_MASK	(0x00030000)	/* DMAC channel selector Mask 10, 11:Don't set */
#define PVCSD_DM_CM_DTRAN_MODE_BUS_WIDTH_8BIT	(0x00000000)	/* Bus width selector 00: 8-bit */
#define PVCSD_DM_CM_DTRAN_MODE_BUS_WIDTH_16BIT	(0x00000010)	/* Bus width selector 01: 16-bit */
#define PVCSD_DM_CM_DTRAN_MODE_BUS_WIDTH_32BIT	(0x00000020)	/* Bus width selector 10: 32-bit */
#define PVCSD_DM_CM_DTRAN_MODE_BUS_WIDTH_64BIT	(0x00000030)	/* Bus width selector 11: 64-bit [default] */
#define PVCSD_DM_CM_DTRAN_MODE_BUS_WIDTH_MASK	(0x00000030)	/* Bus width selector mask */
#define PVCSD_DM_CM_DTRAN_MODE_ADDR_MODE	(0x00000001)	/* System address mode selector 0: fixed address 1: address increment */

/* DM_CM_DTRAN_CTRL */
#define PVCSD_DM_CM_DTRAN_CTRL_DM_SEL		(0x00000100)	/* Command type selector 0 : SD Legacy (UHS-I) command 1: UHS-II SD-TRAN command */
#define PVCSD_DM_CM_DTRAN_CTRL_DM_START		(0x00000001)	/* This bit triggers to start up DMAC. this bit to 1, SDIP operates DMAC transfer	*/
								/* for the channel set by DM_CM_DRAN_MODE.CH_NUM. SDIP clears this bit automatically, 	*/
								/* when SDIP starts up DMAC.								*/

/* DM_CM_INFO1 */
#define PVCSD_DM_CM_INFO1_DTRAN_MASK		(0x000f0000)	/* Interrupt of DMAC data transfer completion DTRANEND[3:2] is reserved. */
#define PVCSD_DM_CM_INFO1_DTRAN_CH_DOWN		(0x00010000)	/* Interrupt of DMAC data transfer completion DTRANEND[0]: Channel0 */
#define PVCSD_DM_CM_INFO1_DTRAN_CH_UP		(0x00020000)	/* Interrupt of DMAC data transfer completion DTRANEND[1]: Channel1 */
#define PVCSD_DM_CM_INFO1_SEQ_SUSPEND		(0x00000100)	/* Interrupt of command sequencer process suspend */
#define PVCSD_DM_CM_INFO1_SEQEND		(0x00000001)	/* Interrupt of command sequencer process completion */

#endif	/* CONFIG_ARCH_PVC */

#endif	/* __ASM_ARCH_PVC_H */

