/*
 * Copyright (C) 2015-2020 Panasonic Corporation.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 */
#ifndef __BOARD_PVC02V_BRB_H
#define __BOARD_PVC02V_BRB_H

/* PVC peripherals static mapping */
#define PVC_KERNEL_UNCACHE_BASE		0xfe000000
#define PVC_KERNEL_UNCACHE_START	CONFIG_PHYS_OFFSET	/* P.A. */
#define PVC_KERNEL_UNCACHE_SIZE		0x00001000

/* SMP synchronous flag */
#define PVC_SMP_SYNC_PADDR		(PVC_KERNEL_UNCACHE_START)
#define PVC_SMP_SYNC_VADDR		(PVC_KERNEL_UNCACHE_BASE)

/* Timer */
#define PVC_CKR_BASE			0xfe001000	/* V.A. */
#define PVC_CKR_START			0x7f038000	/* P.A. */
#define PVC_CKR_SIZE			0x00001000

/* Timer10(20_21), Timer11(22_23) clock */
#define PVC_HCKR_CLK_TIMER10_11_PADDR	(PVC_CKR_START + 0x00000060)
#define PVC_HCKR_CLK_TIMER10_11_VADDR	(PVC_CKR_BASE + 0x00000060)
#define PVC_HCKR_TIMER10_PCLK		0x00000001
#define PVC_HCKR_TIMER10_TIMCLK		0x00000002
#define PVC_HCKR_TIMER11_PCLK		0x00000004
#define PVC_HCKR_TIMER11_TIMCLK		0x00000008

/* Timer10(20_21), Timer11(22_23) reset */
#define PVC_HCKR_RST_TIMER10_11_PADDR	(PVC_CKR_START + 0x00000064)
#define PVC_HCKR_RST_TIMER10_11_VADDR	(PVC_CKR_BASE + 0x00000064)
#define PVC_HCKR_TIMER10_PRESET		0x00000001
#define PVC_HCKR_TIMER11_PRESET		0x00000002

/* Interrupts */
#define NR_IRQS				320

#endif /* __BOARD_PVC02V_BRB_H */
