/*
 * Copyright (C) 2017-2020 Panasonic Corporation.
 */
#ifndef __ASM_BARRIER_H
#define __ASM_BARRIER_H

#ifndef __ASSEMBLY__
#include <asm/outercache.h>

#define nop() __asm__ __volatile__("mov\tr0,r0\t@ nop\n\t");

#if __LINUX_ARM_ARCH__ >= 7 ||		\
	(__LINUX_ARM_ARCH__ == 6 && defined(CONFIG_CPU_32v6K))
#define sev()	__asm__ __volatile__ ("sev" : : : "memory")
#define wfe()	__asm__ __volatile__ ("wfe" : : : "memory")
#define wfi()	__asm__ __volatile__ ("wfi" : : : "memory")
#endif

#if __LINUX_ARM_ARCH__ >= 7

#define isb(option) __asm__ __volatile__ ("isb " #option : : : "memory")
#define dsb(option) __asm__ __volatile__ ("dsb " #option : : : "memory")
#if defined(CONFIG_PVC_PVC02V_BARRIER_REPLACE)
#define dmb(option) __asm__ __volatile__ ( \
	"push	{r0-r2}					\n" \
	"mrs	r0, cpsr				\n" \
	"cpsid	i						\n" \
	"mrc 	p15, 0, r1, c1, c0, 0	\n" \
	"bic 	r2, r1, #4				\n" \
	"mcr 	p15, 0, r2, c1, c0, 0	\n" \
	"mcr 	p15, 0, r1, c1, c0, 0	\n" \
	"msr 	cpsr_c, r0				\n" \
	"pop	{r0-r2}" : : : "memory")
#define PVC_PVC02V_CPU_HZ			624000000	/* 624MHz */
#define PVC_PVC02V_WAIT_NOP_USEC		10		/* 10usec */
#define PVC_PVC02V_BARRIER_REPLACE_NOP_NUM	((PVC_PVC02V_CPU_HZ)/1000/1000 * (PVC_PVC02V_WAIT_NOP_USEC))
#define mb_nop() __asm__ __volatile__ ( \
	"1:	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	nop                    \n" \
	"	subs	%0, %0, #10    \n" \
	"	bgt	1b             \n" \
	:                                  \
	: "r" (PVC_PVC02V_BARRIER_REPLACE_NOP_NUM) \
	: "cc")
#else	/* defined(CONFIG_PVC_PVC02V_BARRIER_REPLACE) */
#define dmb(option) __asm__ __volatile__ ("dmb " #option : : : "memory")
#endif	/* defined(CONFIG_PVC_PVC02V_BARRIER_REPLACE) */


#elif defined(CONFIG_CPU_XSC3) || __LINUX_ARM_ARCH__ == 6
#define isb(x) __asm__ __volatile__ ("mcr p15, 0, %0, c7, c5, 4" \
				    : : "r" (0) : "memory")
#define dsb(x) __asm__ __volatile__ ("mcr p15, 0, %0, c7, c10, 4" \
				    : : "r" (0) : "memory")
#define dmb(x) __asm__ __volatile__ ("mcr p15, 0, %0, c7, c10, 5" \
				    : : "r" (0) : "memory")
#elif defined(CONFIG_CPU_FA526)
#define isb(x) __asm__ __volatile__ ("mcr p15, 0, %0, c7, c5, 4" \
				    : : "r" (0) : "memory")
#define dsb(x) __asm__ __volatile__ ("mcr p15, 0, %0, c7, c10, 4" \
				    : : "r" (0) : "memory")
#define dmb(x) __asm__ __volatile__ ("" : : : "memory")
#else
#define isb(x) __asm__ __volatile__ ("" : : : "memory")
#define dsb(x) __asm__ __volatile__ ("mcr p15, 0, %0, c7, c10, 4" \
				    : : "r" (0) : "memory")
#define dmb(x) __asm__ __volatile__ ("" : : : "memory")
#endif

#ifdef CONFIG_ARCH_HAS_BARRIERS
#include <mach/barriers.h>
#elif defined(CONFIG_ARM_DMA_MEM_BUFFERABLE) || defined(CONFIG_SMP)
#define mb()		do { dsb(); outer_sync(); } while (0)
#define rmb()		dsb()
#define wmb()		do { dsb(st); outer_sync(); } while (0)
#else
#define mb()		barrier()
#define rmb()		barrier()
#define wmb()		barrier()
#endif

#ifndef CONFIG_SMP
#define smp_mb()	barrier()
#define smp_rmb()	barrier()
#define smp_wmb()	barrier()
#else
#define smp_mb()	dmb(ish)
#define smp_rmb()	smp_mb()
#define smp_wmb()	dmb(ishst)
#endif

#define smp_store_release(p, v)						\
do {									\
	compiletime_assert_atomic_type(*p);				\
	smp_mb();							\
	ACCESS_ONCE(*p) = (v);						\
} while (0)

#define smp_load_acquire(p)						\
({									\
	typeof(*p) ___p1 = ACCESS_ONCE(*p);				\
	compiletime_assert_atomic_type(*p);				\
	smp_mb();							\
	___p1;								\
})

#define read_barrier_depends()		do { } while(0)
#define smp_read_barrier_depends()	do { } while(0)

#define set_mb(var, value)	do { var = value; smp_mb(); } while (0)

#define smp_mb__before_atomic()	smp_mb()
#define smp_mb__after_atomic()	smp_mb()

#endif /* !__ASSEMBLY__ */
#endif /* __ASM_BARRIER_H */
